[bits   16]
[org 0x100]
; 
; Keen 1-3 Adlib Music TSR - by Napalm
; BETA - Please do not use this in production mods
; 
; License: Creative Commons Attribution-Share Alike 2.0 UK: England & Wales
; http://creativecommons.org/licenses/by-sa/2.0/uk/
; 
; If you use this all or part of my code please credit me as the license states.
; 
; 

%define ARGC			0x0080
%define ARGV			0x0081
%define INT_CS			bp+4
%define CK123_DGROUP	0x0235 ; CK1 DS Offset
%define CK1_KEENVER		0x1ECD ; CK1 String Offset
%define CK2_KEENVER		0x228B ; CK2 String Offset
%define CK3_KEENVER		0x2387 ; CK3 String Offset
%define CK1_TIMER		0xBE9A ; CK1 Timer Divisor Offset
%define CK2_TIMER		0xB5B2 ; CK2 Timer Divisor Offset
%define CK3_TIMER		0xC910 ; CK3 Timer Divisor Offset
%define CK1_SEGDIF      0x1305 ; CKx Distance (paragraphs) from CSEG to DSEG
%define CK2_SEGDIF      0x1778 ; 
%define CK3_SEGDIF      0x1982 ;
%define CK1_CURLEV      0x8304 ; CKx DSEG offset of current_level
%define CK2_CURLEV      0x803C
%define CK3_CURLEV      0x828C
%define CK1_ERROR       0x359D ; CKx DSEG offset of Missing Text File Error
%define CK2_ERROR       0x3578
%define CK3_ERROR       0x37C8
%define CK1_QUIT        0x1261 ; CKx CSEG error handler offset
%define CK2_QUIT        0x121B
%define CK3_QUIT        0x11BF

%define TIMERPULSE      0x0012305E
%define MUSICDIV	    (TIMERPULSE / 560) ; keen 6 timer divisor
%define ADLIB_ADDR	    0x0388

%define MUSICBUFFERSIZE 0x8000 ; buffer for IMF file

%define FILESIZE 0x400
%define LISTSIZE 91*16

%macro quitp 0
    mov ah, 0x4C
    mov al, 0
    int 0x21
%endmacro

%macro breakpoint 0
	mov  ax, 0x0003
	int  0x10
	int3
%endmacro

[segment .data]
	credits			db "Keen 1-3 Adlib Music TSR - by Napalm", 10, 13, '$'
	tsrinstall		db "Installed on INT 0x65", 10, 13, "Use /U switch to uninstall.", 10, 13, '$'
	tsrremove       db "Removing Adlib Music TSR...", 10, 13, '$'
	tsruninstall	db "Uninstalled from INT 0x65", 10, 13, '$'
	tsralready		db "Already installed on INT 0x65", 10, 13, '$'
	tsrnotinstall	db "TSR is not installed, so cannot uninstall!", 10, 13, '$'
	tsrerror		db "Error: Cannot go into TSR mode!", 10, 13, '$'
	vector65		dd 0
	vector08		dd 0
	timer_count		dw 0
    switch          dw 0
    int8_installed  dw 0	
    PSP             dw 0

	keen_cs			dw 0 
	keen_ds			dw 0
	keen_episode    dw 0 ; current keen episode being played
	keen_level      dw 0 ; current level being played
	level_table     dw CK1_CURLEV, CK2_CURLEV, CK3_CURLEV ; offsets in CK DSEG
	error_msg_table dw CK1_ERROR, CK2_ERROR, CK3_ERROR ;
	error_jmp_table dd CK1_QUIT, CK2_QUIT, CK3_QUIT	
	
	adliberror		db "Error: Cannot detect adlib compatible card!", 10, 13, '$'
	musichandle		dw 0
	musicpointer    dw 0 ; position in IMF
	musicadlib		dw 0
	musicpause		dw 0 ; delay counter
	musicstop       dw 0 ; 1 = music off
	musicsize		dw 0
	align 16
	musicbuffer     times MUSICBUFFERSIZE db 0
	
	buffer			db 0, 0, 0, 0, 0x20, 0, 0, 0, 0, 0x20, 0x0A, 0x0D
	found			db "FOUND!", 0x0A, 0x0D, 0x24
	
; ==== loading stuff

    songfile         db "songlist.lst", 0
    testfile         db "testout.out", 0
    filehandle       dw 0
    filelength       dw 0


    filebuffer      db "  "
    filebuffer1     times FILESIZE db 0
    align 16
    listarray       times LISTSIZE db 0

	
[segment .text]
	start:
		; make sure our segment selectors are correct
		mov  ax, cs
		mov  ds, ax
		
		; print credits
		mov  ah, 0x09
		mov  dx, credits
		int  0x21

		; save PSP
		mov  ah, 0x51
		int  0x21
		mov  word [PSP], bx
	
		; get switch into var
		cmp  byte [ARGC], 0x03
		jne  short .detectadlib
		mov  ax, word [ARGV+0x01]
		or   ah, 0x20 ;set to lowercase
		mov  [switch], ax
	
	.detectadlib:
		; detect adlib card
		clc
		call adlib_detect
		jc   short .getvector
		mov  ah, 0x09
		mov  dx, adliberror
		int  0x21
		jmp  exit
		
	.getvector:
		; get current int 0x65 vector handler
		mov  ax, 0x3565
		int  0x21
		mov  [vector65+0x00], bx
		mov  [vector65+0x02], es
		
		; detect if we are already installed
		mov  cx, es
		or   cx, bx
		cmp  cx, 0
		jz   short .installz
		mov  ah, 0xAA
		int  0x65
		cmp  ah, 0x55
		je   short .already
		jmp  short .install
		
	.already:
		; check for uninstall switch
		cmp  word [switch], '/u'
		je   short .uninstall
		; print already installed message
		mov  ah, 0x09
		mov  dx, tsralready
		int  0x21
		mov  ah, 0x01
		jmp  exit
		
		; no previous vector set default
	.installz:
		mov  word [vector65+0x00], iretvector
		mov  word [vector65+0x02], cs
		
		; install interrupt handler
	.install:
		; check for uninstall switch
		cmp  word [switch], '/u'
		je   short .notinstall
		
		; set interrupt vector
		mov  ax, 0x2565
		mov  dx, handler65
		int  0x21
		
		; tell user we have installed TSR
		mov  ah, 0x09
		mov  dx, tsrinstall
		int  0x21
		
		; calculate end of required memory
		mov  dx, tsrend     ; the address already has psp base of 0x100
		mov  cl, 0x04       ; keep dos debug happy with disassembly
		shr  dx, cl         ; divide by 16 (paragraph size)
		inc  dx             ; add 1 page for saftey
		
		; exit but stay resident
		mov  ax, 0x3100     ; ah = TSR, al = return code 0
		int  0x21           ; call dos dispatch handler
		
		; failed, so set interrupt vector back, then print message and exit
		mov  ax, 0x2565
		lds  bx, [vector65]
		int  0x21
		mov  dx, tsrerror   ; address of string
		mov  ah, 0x09       ; ah = print string terminated by $
		int  0x21           ; call dos dispatch handler
		mov  al, 0x01		; return code 1
		jmp  short exit
		
		; print message that we are not installed
	.notinstall:
		mov  ah, 0x09
		mov  dx, tsrnotinstall
		int  0x21
		jmp  short exit
		
		; tell interrupt to uninstall tsr
	.uninstall:
		mov  ah, 0x55
		int  0x65
		xor  al, al
		
	exit:
		mov  ah, 0x4C       ; exit with return code in al
		int  0x21           ; call dos dispatch handler
		
;===============================================================================

    	; returns: cf = 1 found, 0 error
	adlib_detect:
		pusha
		mov  ax, 0x0460 ; reset both timers
		call adlib_write
		mov  ax, 0x0480 ; enable timer interrupts
		call adlib_write
		call adlib_read ; store status register
		mov  bl, al
		mov  ax, 0x02FF
		call adlib_write
		mov  ax, 0x0421 ; start timer 1
		call adlib_write
		mov  cx, 0x0001 ; delay
        mov  dx, 0x3880
		mov  ah, 0x86
		int  0x15
		call adlib_read
		mov  bh, al
		mov  ax, 0x0460 ; reset both timers
		call adlib_write
		mov  ax, 0x0480 ; enable timer interrupts
		call adlib_write
	.checkstats:
		and  bl, 0xE0
		jnz  short .notfound
		and  bh, 0xE0
		cmp  bh, 0xC0
		jne  short .notfound
		stc
		jmp  short .endsub
	.notfound:
		clc
	.endsub:
		popa
		ret

;===============================================================================	
	    ; assumes and returns: none
	    ; write 0 to all reg
	adlib_reset:
		push ax
		mov  ax, 0x0100
	.loop:
		call adlib_write
		inc  ah
		cmp  ah, 0xF6
		jb   short .loop
		mov  ax, 0x0120
		call adlib_write
		mov  ax, 0x0800
		call adlib_write
		pop  ax
		ret

;===============================================================================		
		; assumes: ah = reg, al = data
	adlib_write:
		push ax
		push dx
		push cx
		pushf
		cli
		mov  dx, ADLIB_ADDR
		xchg al, ah
		out  dx, al
		popf
		mov  cx, 0x06
	.loop1:
		in   al, dx
		loop .loop1
		xchg al, ah
		inc  dx
		out  dx, al
		dec  dx
		mov  cx, 0x23
	.loop2:
		in   al, dx
		loop .loop2
		pop  cx
		pop  dx
		pop  ax
		ret
;===============================================================================		
		; returns: al = byte
	adlib_read:
		push dx
		mov  dx, ADLIB_ADDR
		in   al, dx
		pop  dx
		ret

;===============================================================================
        ; assumes none returns none
        ; set reg B0-B8, BD to zero (silences adlib)
    adlib_off:
        push ax
        push cx
        
        mov  ah, 0xBD
        mov  al, 0
        call adlib_write
        
        mov  ah, 0xB0
        mov  al, 0
        mov  cx, 9
    .loop1:
        call adlib_write
        inc  ah
        loop .loop1
        pop  cx
        pop  ax
        ret

;===============================================================================		
	align 16
	handler65:
		push bp
		mov  bp, sp
		pusha
		push ds
		push es
		push fs
		
		push cs
		pop  ds
		
		; if install came from keen (AX = 0x2508), hack keen divisor
		; also save keen seg000 (cseg) and dseg for later
	.keencheck:
		cmp  ax, 0x2508
		je   short .versioncheck
		
		; else check if INT was request for 'installed' (check if installed)
	.installcheck:
		cmp  ah, 0xAA
		jne  short .uninstallcheck
		mov  byte [ss:bp-0x01], 0x55 ; set return ah = 0x55
		jmp  .endisr
		
		; check if INT was request for 'uninstall'
	.uninstallcheck:
		cmp  ah, 0x55
		jne  .endisr
		
		; uninstall TSR and print message
		; 
	.uninstall:
	
	    ; reset adlib
	    call adlib_off
	    call adlib_reset
	    
	    push ds
        mov  ax, 0x2565             ; restore old interrupt 65
        mov  dx, [vector65+0x00]
        mov  ds, [vector65+0x02]
        int  0x21
        pop  ds
        
        mov  es, [PSP]
        mov  es, [es:0x2C]   ; Get address of environment block.
        mov  ah, 0x49        ; DOS deallocate block call.
        int  0x21

        mov  es, [PSP]       ; Now free the program's memory
        mov  ah, 0x49        ;  space.
        int  0x21
        
        mov  ah, 0x09        ; print message
		mov  dx, tsruninstall
		int  0x21
		jmp  .endisr

    ;Get difference between keen dseg and keen cseg to determine episode
    .versioncheck:
   
		mov  fs, word [ss:INT_CS] ; cs from caller
		mov  es, word [fs:CK123_DGROUP] ; keen dseg
		mov  ax, es
		mov  bx, fs
		sub  ax, bx
		
    .keen1:
	    cmp  ax, CK1_SEGDIF
	    jne  .keen2
		; hack keen1 timer divisor
		mov  word [fs:CK1_TIMER], MUSICDIV
		mov  word [keen_episode], 1
		jmp  short .keenfound
		
	.keen2:
	    cmp  ax, CK2_SEGDIF
	    jne  .keen3
		; hack keen2 timer divisor
		mov  word [fs:CK2_TIMER], MUSICDIV
		mov  word [keen_episode], 2
		jmp  short .keenfound
		
	.keen3:
	    cmp  ax, CK3_SEGDIF
	    jne  .installcheck ; isn't keen x.31
		; hack keen3 timer divisor
		mov  word [fs:CK3_TIMER], MUSICDIV
		mov  word [keen_episode], 3
		jmp  short .keenfound
		
	.keenfound:
		; found keen save segments for possible future use
		mov  [keen_cs], fs
		mov  [keen_ds], es
		
		; reset the adlib card and get things ready
		call adlib_reset
		;mov  word [keen_level], 90 ; first level loaded is 90
		
		; install us as vector owner and we will call keens interrupt
		xor  ax, ax
		mov  [timer_count], ax
		mov  [musicpause], ax
		mov  ax, word [ss:bp-0x06] ; dx from caller
		mov  bx, word [ss:bp-0x12] ; ds from caller
		mov  [vector08+0x00], ax
		mov  [vector08+0x02], bx
		
		; Handle keen uninstall int 08 call
		; if keen episode is set, then reset and uninstall our int 08
		cmp  word [int8_installed], 0
		je   short .install08
		
		.uninstall08:
	    call adlib_off
	    call adlib_reset
		mov  word [int8_installed], 0
		push ds
		mov  ds, bx
		mov  dx, ax
		mov  ax, 0x2508
		; TODO: detect INDOS flag
		int  0x21
		pop  ds
		jc   .exitkeen
		jmp  short .endisr
		
	.install08:
		mov  dx, handler08
		mov  ax, 0x2508
		; TODO: detect INDOS flag
		int  0x21
        call loadlist
	    jc   .exitkeen
	    mov  word [int8_installed], 1
	
	.endisr:
		pop fs
		pop es
		pop ds
		popa
		pop bp
		jmp far [cs:vector65] ; call old handler to complete interrupt
		
    .exitkeen:
        mov  bx, [keen_episode]
        dec  bx
        shl  bx, 1
        push word [error_msg_table+bx]
        push bx  ; dummy call stack (keen exit func does not return)
        push bx  ; near call, arg is at bp+4
        shl  bx, 1
        mov  ax, [keen_cs]
        mov  [bx+2], ax
        jmp far [error_jmp_table+bx]
		
;===============================================================================	
	align 16
	handler08:
		push ds
		push es
		pusha
		push cs
		pop  ds
		
	    ; check keen level to see if changed
	.levelcheck:
	    mov  es, [keen_ds]
	    mov  bx, [keen_episode]
	    dec  bx
	    shl  bx, 1
	    mov  bx, [bx+level_table]
	    mov  ax, [es:bx]
	    cmp  ax, [keen_level]
	    jne  .changelevel 
     
     ; TODO: add other checks here according to list directives
     
	    jmp  .playsong
	       
	    ; change song due to level change   
	.changelevel:
	    mov  [keen_level], ax
	    call loadsong
	    jc   .songerror
	    mov  word [musicpause], (TIMERPULSE / MUSICDIV) ; one second break
	    mov  word [musicstop], 0 ; play song	
	    jmp  .playsong
    
	.songerror:
	    call adlib_off
	    mov  word [musicstop], 1
	    
	.playsong:
	    cmp  word [musicstop], 0     ; stop music indefinitely
	    jnz  .endisr
		mov  cx, [musicpause]   ; pause for X cycles
		cmp  cx, 0
		jne  .carryon
		mov  si, musicpointer
	
	.readreg:
		mov  bx, musicbuffer
		add  bx, [si]
		mov  ax, word [bx+0x00] ; adlib data
		mov  cx, word [bx+0x02] ; delay
		xchg al, ah
		call adlib_write
		add  word [si], 4
		mov  di, [musicsize]
		cmp  word [si], di
		jae   .rewind
		or   cx, cx
		jz   short .readreg
		jmp  short .carryon
	.rewind:
		mov  word [si], 2 ; TODO: add no-rewind options to songs
		mov  cx, 1        ; set musicpause to 0
	.carryon:
		dec  cx
		mov  word [musicpause], cx

        ; call keen.exe int8 every 4th time
	.endisr:
		mov  bx, timer_count
		inc  word [bx]
		cmp  word [bx], 4
		je   short .callkeen
		popa
		pop  es
		pop  ds
		jmp  short iretvector
	.callkeen:
		xor  ax, ax
		mov  [bx], ax

		popa
        pop  es
   		pop  ds
		jmp  far [cs:vector08]

;===============================================================================		
	align 16
	iretvector:
		push ax
		mov  al, 0x20
		out  0x20, al
		pop  ax
		iret

;===============================================================================
        ; load song into musicbuffer, cf=1 --> error in File I/0
        ; assumes ax = song index
    loadsong:
    
        ; open song from songlist
        mov  dx, ax
        shl  dx, 4
        add  dx, listarray
     	mov  ah, 3Dh 
    	mov  al, 0
    	int  0x21
        jc   .retloc
       	mov  bx, ax
    	mov  [musichandle], ax
   	   	
    	mov  ah, 0x3F ;read into buffer
    	mov  cx, MUSICBUFFERSIZE
     	mov  dx, musicbuffer
    	int  0x21
    	jc   .retloc
    	mov  [musicsize], ax
    	
    	;set music size if type1 IMF
    	mov  ax, [musicbuffer]
    	or   ax, ax
    	jz   .close
    	mov  [musicsize], ax
    	
    .close:
    	mov  ah, 0x3E ;close
    	int  0x21
   		jc   .retloc
   		
        ; rewind
    	mov  word [musicpointer], 2
    	call adlib_off
        
        clc
   		
   	.retloc:
		retn

;===============================================================================
    ; load songs into songlist array from file
    ; cf set if error
   
    loadlist:
        push es
        pusha
        push ds     
        pop  es
        
        ; clear the list buffer
        mov  ax, 0
        mov  cx, LISTSIZE
        mov  di, listarray
        rep  stosb

        ; load file into filebuffer
        mov  dx, songfile ;open
        mov  ax, 0x3D00
        int  0x21
        jc   .retloc1
        mov  bx, ax
        mov  [filehandle], ax
                
        mov  ah, 0x3F ;read into buf
        mov  cx, FILESIZE
        mov  dx, filebuffer1
        int  0x21
        jc   .retloc1
        mov  [filelength], ax
        
        mov  ah, 0x3E
        int  0x21
        jc   .retloc1
  
        ; add %x after filebuffer to ensure exit
        mov  bx, filebuffer
        add  bx, [filelength]
        mov  [bx+1], dword `\n %x`
        
        ; point si to start of first token (starting at whitespace)    
        mov  si, filebuffer
        
    .parsetoken:
        mov  bx, si
        mov  ax, 0
        mov  dx, 0
        call next_token
        mov  si, ax
        cld
        lodsb
        cmp  al, byte '#' ; comment line
        je   .do_comment
        cmp  al, byte '%' ; directive line
        je   .do_directive
        jmp  .parsetoken
        ;jmp  .retloc1 ; BAD INSTRUCTION

    .do_comment:
        mov  di, si
        mov  al, byte `\n` ; search until directive
        cld
        repne scasb
        mov  si, di
        dec  si
        jmp  .parsetoken
        
    .do_directive:  
        lodsb
        cmp  al, 'l'            ; level song
        je  .do_directive_l       
        cmp  al, 'x'            ; end list file
        je .do_directive_x
        ; TODO: more options go here... change song at item pickup etc
        jmp .retloc1  ; BAD INSTRUCTION  
   
        ; %l <levelnum> "song.imf"
    .do_directive_l:
        mov  bx, si
        mov  ax, 0
        mov  dx, 0
        call next_token         ; point si to start of <levelnum>
        mov  si, ax
        mov  bx, ax
        call dec_to_word        ; save levelnum in di
        jc   .retloc1
        mov  di, ax
        mov  bx, si
        mov  ax, 0
        mov  dx, 0
        call next_token         ; point si to start of "song.imf"
        mov  si, ax
        mov  bx, ax
        mov  ax, di
        call load_song_to_list  ; move filename to index in list
        mov  bx, si            
        mov  ax, 0
        mov  dx, 0
        call next_token         ; point si to next token after "song.imf"
        jc   .retloc1           ; ERROR FILE I/O
        jmp  .end_directive
    
        ; no more instructions           
    .do_directive_x:
        jmp  .retloc0
        
    .end_directive:
        jmp  .parsetoken

    .retloc1:
        stc     
              
    .retloc0:
        popa
        pop  es
        retn

        
;===============================================================================
        ; assumes [ds:bx] points at start of unsigned ascii decimal string
        ; returns value in ax, cf = 1 if error
       
    dec_to_word:
        ; point bx immediately after ones digit
        mov  ax, 0
        mov  dx, 1
        call next_token
        mov  bx, ax ;good
                
        ; process digits from ones leftwards
        mov  dx, 0 ; sum
        mov  cx, 1 ; digit counter
    .getchar:
        dec  bx
        movzx ax, [bx]
        cmp  al, ' '    ; whitespace = done
        je  .retloc
        cmp  al, `\t`
        je  .retloc
        cmp  al, `\n`
        je  .retloc
        cmp  al, `\r`
        je  .retloc       
        cmp  al, '0'    ; unallowed character
        jb   .retloc1
        cmp  al, '9'
        ja   .retloc1
        
        sub  al, '0'
        imul ax, cx
        add  dx, ax
        jc   .retloc1  ; overflow
        imul cx, 10
        jmp  .getchar

   .retloc:    
        mov  ax, dx
        clc
        retn
        
    .retloc1:
        stc
        retn
        
 

;===============================================================================
        ; assume: bx points somewhere inside string, ax = 0 search fwd, ax = 1 search bkwd
        ;   dx = 0 search for token start, dx = 1 search for whitespace start
        ; returns: ax points to start of next/previous token or w.s.
        ; (if bx points to nonwhite and ax =0, then return ax at start of this token or w.s.
        ; w.s. defined as space, tab, newline, CR

    next_token:
        push si             ; si = cmp offset (fwd = 0, rev = -1)
        push di             ; di = increment  (fwd = 1, rev = -1)
        push ax
        neg  ax
        mov  si, ax
        shl  ax, 1
        inc  ax
        mov  di, ax
        pop  ax
        xor  ax, dx
        jz   .fllf0
        jmp  .lffl0
        
    .fllf1:
        add  bx, di
    .fllf0:
        mov  al, [bx+si]
        cmp  al, ` `
        je   .fllf2
        cmp  al, `\t`
        je   .fllf2
        cmp  al, `\n`
        je   .fllf2
        cmp  al, `\r`
        je   .fllf2        
        jmp  .fllf1
    
    .fllf2:
        add  bx, di
        mov  al, [bx+si]
        cmp  al, ` `
        je   .fllf2
        cmp  al, `\t`
        je   .fllf2
        cmp  al, `\n`
        je   .fllf2
        cmp  al, `\r`
        je   .fllf2     
        jmp  .return
        
    .lffl1:
        add  bx, di
    .lffl0:
        mov  al, [bx+si]
        cmp  al, ` `
        je   .lffl1
        cmp  al, `\t`
        je   .lffl1
        cmp  al, `\n`
        je   .lffl1
        cmp  al, `\r`
        je   .lffl1        
      ; jmp  .lffl2
    
    .lffl2:
        add  bx, di
        mov  al, [bx+si]
        cmp  al, ` `
        je   .return
        cmp  al, `\t`
        je   .return
        cmp  al, `\n`
        je   .return
        cmp  al, `\r`
        je   .return
        jmp  .lffl2
        
    .return:
        mov  ax, bx
        pop  di
        pop  si
        retn

;===============================================================================        
        ; assume ds:bx points at double quoted filename (12 chars or less)
        ; ax = song number
        ; copies filename from filebuf to entry in list
        ; sets carry if error
    load_song_to_list:
    
        push si
        push di
        
        ; set indices
        cld
        mov  si, bx
        mov  di, listarray
        shl  ax, 4
        add  di, ax
        mov  dx, di
        
        ; copy file to list array
        lodsb
        cmp  al, `\"`
        jne  .retloc
        mov  cx, 12
    .nextchar:
        cmp  byte [si], `\"`
        je   .donefile
        movsb
        loop .nextchar

        ; open file to see if present (dx saved from before)
    .donefile:
        mov  ah, 0x3D
        mov  al, 0
        int  0x21
        jc   .retloc
        
        mov  bx, ax
        mov  ah, 0x3E
        int  0x21
        
    .retloc:
        pop  di
        pop  si
        retn

;===============================================================================      
       
	
[segment .bss]
tsrend:
