#############################################
#Files, Graphics &c                         #
#############################################

%ext ck4
%patchfile $2107F "EGAHED.CK4" #Change the graphics,
%patchfile $2482F "maphed.ck4" #and the map headers!
%patchfile $249C2 "Keen4.tli"   #Tileinfo


#############################################
#Keen Related Patches                       #
#############################################

#Keen will be exploded when he stands on mine (Moon) tiles
%patch $BBFC  $30 $00 #Look up command time (1s) This is the time a mine takes to 'activate'
%patch $BC16  $04 $00 #Shrug-blink or explode(Moon) this will kill Keen
%patch $BC06  $8C $09 #Erase the 1st bored 'look up' action command
%patch $BC3A  $AA $09 #Use the 'look up' action to ins long pause so 'shrug-blink' acts like normal
%patch $3070C $F1 $00 #Gems Cache start (Changed to include anim 117 for last exploding animation)
%patch $2F81A $008AW $0082W $0003W $0000W $0001W $01C0W $00000000L #Change this so it looks like standing Keen;
              $0395W $0B80RW $A9 $14 $0B80RW $1AA2W $0B80RW $09C8W #Pause 1C0 + 34 = 1F4 = normal time, now go to shrug-blink
%patch $2F8EC $0207W $0207W $0003W $0000W $0001W $0010W $00000000L #Set all behaviors to $00 so that
              $00000000L $A9 $14 $0B80RW $A2 $1A $0B80RW $9A $0A   #Keen can't stop mooning by moving;
%patch $2F90A $0208W $0208W $0003W $0000W $0001W $0010W $00000000L #Change a few other misc details too,
              $00000000L $A9 $14 $0B80RW $A2 $1A $0B80RW $B8 $0A   #Times are also changed
%patch $2F928 $00A4W $00A4W $0003W $0000W $0001W $0010W $00000000L #Here we use knockout star anims
              $00000000L $A9 $14 $0B80RW $A2 $1A $0B80RW $E0 $24   #And it then goes to skypest preening anim
%patch $31350 $00A5W $00A5W $0003W $0000W $0001W $0010W $00000000L #Use spare Skypest grooming actions
              $00000000L $A9 $14 $0B80RW $A2 $1A $0B80RW $FE $24   #Change them to keenish actions
%patch $3136E $00A6W $00A6W $0003W $0000W $0001W $0010W $00000000L
              $00000000L $A9 $14 $0B80RW $A2 $1A $0B80RW $1C $25
%patch $3138C $00F1W $00F1W $0003W $0000W $0001W $0010W $00000000L
              $00000000L $A9 $14 $0B80RW $A2 $1A $0B80RW $3A $25
%patch $313AA $FFFFW $FFFFW $0003W $0000W $0001W $0064W $00000000L #$FF, show no sprite here
              $00000000L $A9 $14 $0B80RW $A2 $1A $0B80RW $CE $36   #And then go to 'die' ($36CE)


#Make Keen die if he stands still too long! (Time worm eats)
%patch $2F946 $00A3W $00A3W $00000000L $0001W $0010W $00000000L 
              $00000000L    $0B8014A9RL $0B801AA2RL  $0AF4W
%patch $2F964 $0096W $0096W $00000000L $0001W $0010W $00000000L 
              $00000000L    $0B8014A9RL $0B801AA2RL  $0B12W
%patch $2F982 $0097W $0097W $00000000L $0001W $0010W $00000000L 
              $00000000L    $0B8014A9RL $0B801AA2RL  $0B30W
%patch $2F9A0 $0098W $0098W $00000000L $0001W $0010W $00000000L 
              $00000000L    $0B8014A9RL $0B801AA2RL  $0B4EW
%patch $2F9BE $0099W $0099W $00000000L $0001W $0010W $00000000L 
              $0B80045CRL $0B8014A9RL $0B801AA2RL  $0B6CW
%patch $2F9DC $009AW $009AW $00000001L $0001W $0010W $00000000L 
              $0B80045CRL $0B8014A9RL $0B801AA2RL  $0B8AW
%patch $2F9FA $FFFFW $FFFFW $00000000L $0001W $0010W $00000000L 
              $0B80045CRL $0B8014A9RL $0B801AA2RL  $0BA8W
%patch $2FA18 $009CW $009CW $00000000L $0001W $0010W $00000000L 
              $0B80045CRL $0B8014A9RL $0B801AA2RL  $0BC6W
%patch $2FA36 $009DW $009DW $00000000L $0001W $0010W $00000000L 
              $0B80045CRL $0B8014A9RL $0B801AA2RL  $0BE4W
%patch $2FA54 $009EW $009EW $00000000L $0001W $0010W $00000000L 
              $0B80045CRL $0B8014A9RL $0B801AA2RL  $3854W
%patch $326C4 $009FW $009FW $00000000L $0001W $0010W $00000000L 
              $0B80045CRL $0B8014A9RL $0B801AA2RL  $3872W
%patch $326E2 $009BW $009BW $00000000L $0001W $0110W $00000000L 
              $0B80045CRL $0B8014A9RL $0B801AA2RL  $36CEW
%patch $3255A $CE $36 #Keen disappears after being eaten
%patch $32548 $14 $00 #Pause till level exit
%patch $BC45  $00 $04 #Increase reading time, just for the hell of it

%patch $30264 $20 $03 #Red gem (800)
              $20 $03 #Yellow gem (800)
              $20 $03 #Blue gem (800)
              $20 $03 #Green gem (800)
              $64 $00 #100 (100)
              $C8 $00 #200 (200)
              $90 $01 #500 (400)
              $40 $06 #1000 (1600)
              $80 $0C #2000 (3200)
              $00 $19 #5000 (6400)
              $00 $64 #1UP (25600 = 2 lives)
              $32 $00 #Raygun (50)
#Ammo rayguns give Keen
%patch $30246 $0A $00 #Easy (10)
              $05 $00 #Medium (5)
              $14 $00 #Hard (20)
%patch $E63C  $0F $00 #Keen's bullet zap can be stood on [Impossible bullet trick]
%patch $8782  $00 $00 #Keen can't look up or down (Screen doesn't move)
%patch $2FC8E $0094W $0094W #Keen looks at player when placing gem


#############################################
#Sprite Related Patches                     #
#############################################

#Connected sprites:
#Smirky->everything
#Faling airboard->Zoltan
#Schoolfish->mine + skypest
#Wetsuit->Berkeloid
#Mines-> keygem, -> bombspr (Berk?)
#Maybe connect arachnut -> sprite? (2 Extra recovering frames)
#Maybe arach-> skypest (Many anims left over, maybe use spr bull sp for small arach?)


###
#Misc sprite alterations
###
%patch $B7B3  $04 $00 #Stop the knockout stars appearing
%patch $B9C0  $20 $00 #Keen can enter doors 1 tile wide (Walks right 2 pixels instead of 6)
#Reverse the Dopefish\schoolfish defaults (3 diffs of schoolfish)
%patch $12112 $64 $37 #Spawn Schoolfish [Swim]
%patch $12508 $C0 $35 #Spawn Dopefish [Swim]
%patch $306F8 $A5 $01 #Dopefish Cache start
%patch $30742 $A8 $01 #Dopefish cache end
%patch $306FA $94 $01 #Schoolfish Cache start
%patch $30744 $A4 $01 #Schoolfish cache end
#Reverse Skypest and Egg sprite defaults (Allow 3 difficulties of Egg alarm)
%patch $10656 $20 $21 #Skypest now an egg
%patch $1001D $86 $24 #Egg a Skypest
%patch $306FE $6A $01 #Skypest Cache start (Switch caches around)
%patch $30748 $6E $01 #Skypest cache end
%patch $30718 $BB $01 #Egg Cache start
%patch $30762 $C8 $01 #Egg cache end
%patch $30730 $C8 $01 #Slug cache end (Now includes skypests automatically)
%patch $30746 $AE $01 #Arachnut cache end (Add wetsuit)
#Make all enemies 'explode' when they dissapear
%patch $30EF8 $FE $33 #Poison Slug [Third frame, smaller]
%patch $30EE6 $10 $00 #Animation
%patch $31FD8 $C2 $33 #Lick
%patch $31FC6 $10 $00 #Animate
%patch $3242E $C2 $33 #Mimrock
%patch $3133C $10 $00 #Animation
%patch $32230 $C2 $33 #Smirky
%patch $3221E $10 $00 #Animation
%patch $3170E $C2 $33 #Wormouth
%patch $107BA $C6 $20 #Landed Skypest (Drying slime)
%patch $105A9 $C2 $33 #Arachnut
%patch $3225E $00     #Stop candysmash moving?
%patch $3227C $00     #Also use variants; E0,FE,41C
%patch $3229A $00


###
#Council Member
###
#Transform member into hologram of Zoltan:
%patch $FD2F  $00 $00 #Stop the Member walking
%patch $FD3A  $00 $00
%patch $30E28 $64 $01 $64 $01 #Change sprites so only two are used:
%patch $30E46 $65 $01 $65 $01
%patch $30E64 $66 $01 $66 $01
%patch $30E32 $1A $00 #Slow animation
%patch $30E50 $2A $00
%patch $30E6E $2A $00
%patch $30E80 $52 $3A #Instead of going to walking, use the new actions:
%patch $328C2 $FFFFW $FFFFW $0000W $0000W $0000W $004AW  $0000W $0000W
              $0000W $0000W $0000W $0000W $176EW $09DCRW $3A70W #Invisible
%patch $328E0 $0166W $0166W $0000W $0000W $0000W $002AW  $0000W $0000W
              $0000W $0000W $0000W $0000W $176EW $09DCRW $1FD6W #1/4 visible...
%patch $306F2 $64 $01 #Council Member Cache start
%patch $3073C $67 $01 #Council member cache end
%patch $FD19  $0F $FF #Spawn height: 15 pixels up
%patch $FD72  $73     #Increase thinking freq


###
#Poison slug
###
#Slug is the slow but armored rock monster; it slimes twice as often and longer, can't
#be shot unless sliming and crawls slower
%patch $FDAE  $CF $FF #Spawn 3 pixels up
%patch $FE48  $0E $01 $00 #Slug slime has initial speed
%patch $FE5B  $A2 $26 #Poison slug slime [Forms 2nd to last Skypatch 'egg']
%patch $10751 $A8 $20 #Egg squishes to slime
%patch $3151C $A4 $00 #Laid egg waiting time
%patch $3153A $14 $00 #Cracked egg hatching time
%patch $31512 $C6 $01 $C6 $01 #Egg sprites
%patch $30F2C $00 $00 $00 $00 #Slime doesn't hurt Keen
%patch $FEB3  $00 $00 #More reactive when shot
%patch $30EC8 $6C $00 #Increase sliming time (Give Keen a chance!)
%patch $FE49  $03 $00 #Poison Slug slime appears in front of all tiles
%patch $FFFB  $02 $00 #Skypest appears in front of all tiles [Alter EGG foreground]
%patch $30E82 $40 $01 $3B $01 $00 $00 $00 $00 $01 $00 $04 $00 $10 $00 $00 $00
              $0369W $0FA8RW $04BEW $0FA8RW  #Mushroom hit, crawl less but anim faster
%patch $30EA0 $41 $01 $3C $01 $00 $00 $00 $00 $01 $00 $04 $00 $10 $00 $00 $00
              $0369W $0FA8RW $04BEW $0FA8RW  #Same as above [4*10 vs 8*40]
%patch $FE93  $8A $20 #Always spawn 'short' shot slug
%patch $30EFA $3E $01 $3E $01 $01 $00 $00 $00 $00 $00 $06 $00 $00 $00 $00 $00
              $16C9W $09DCRW $04BEW $0FA8RW $1913W $09DCRW $6C $20 #Shot slug flips to next slug


###
#Mad Mushroom
###
#Mad mushroom is a 4x2 anim spinder
#Note we slow its fall with int3 = 1
%patch $30F54 $46 $01 $46 $01 $01 $00 $00 $00 $00 $00 $18 $00 $00 $00 $00 $00
              $0493W $0FA8RW $04BEW $0FA8RW $04ECW $0FA8RW $02 $21
%patch $30F72 $45 $01 $48 $01 $01 $00 $00 $00 $00 $00 $18 $00 $00 $00 $00 $00
              $0C85W $0FA8RW $04BEW $0FA8RW $04ECW $0FA8RW $8E $3A #Move to action 3
%patch $328FE $46 $01 $47 $01 $01 $00 $00 $00 $00 $00 $18 $00 $00 $00 $00 $00
              $0C85W $0FA8RW $04BEW $0FA8RW $04ECW $0FA8RW $AC $3A #Move to action 4
%patch $3291C $47 $01 $46 $01 $01 $00 $00 $00 $00 $00 $18 $00 $00 $00 $00 $00
              $0C85W $0FA8RW $04BEW $0FA8RW $04ECW $0FA8RW $E4 $20 #Return to action 1
%patch $FF1F  $44 $0E $3D $01 #Mushroom flickers left and right in action 1
#This changes the skypest death and gives the mushroom something to do besides spin in actions 2-4:
%patch $106D7 $55 $8B $EC $56 $57 $8B $7E $06 $8B $76 $08 $83 $C7 $4C $83 $3C
              $03 $75 $0D $56 $9A $0D43W $0D8FRW  $83 $C4 $02 $5F $5E $5D $CB
              $83 $3C $02 $75 $05 $9A $13E9W $0B80RW  $5F $5E $5D $CB $55 $8B
              $EC $56 $8B $76 $06 $8B $1E $D6 $A7 $8B $47 $0A $3B $44 $0A $73
              $07 $C7 $44 $10 $FF $FF $EB $05 $C7 $44 $10 $01 $00 $56 $9A $1315W
                  $09DCRW $83 $C4 $02 $5E $5D $CB
%patch $FF9C  $9C $FF #high jump height (Also changes jump speed)
%patch $FF7C  $A0 $00 #Mushroom whacks down from ceilings
%patch $FFAD  $32 $00 #Mad Mushroom low jump sound
%patch $FF9F  $30 $00 #Mad Mushroom high bounce sound
%patch $FF90  $04 $00 #Mushroom's 4th jump is high
%patch $FF97  $03 $00 #After that ALL jumps are high


###
#Egg
###
#Egg becomes an alarm that releases a Bird every $E0 clicks
%patch $30FAE $6C $01 $6C $01 $00 $00 $00 $00 $00 $00 $E0 $00 $00 $00 $00 $00
              $00 $00 $00 $00 $0701W $0FA8RW $176EW $09DCRW $20 $21 #Large shell regenerates into egg can be shot
%patch $1017D $5F $5E $5D $CB #Spawn only one fragment from egg (Frees 10181-101F8)
%patch $10169 $00 $00 $C7 $47 $18 $00 $00 #Left fragment sits still 
%patch $30FCC $6C $01 $6C $01 $00 $00 $00 $00 $00 $00 $E1 $00 $00 $00 $00 $00
              $00 $00 $00 $00 $00 $00 $00 $00 $097FW $0FA8RW $C2 $33 #Shell fragment disappears after $E1
%patch $100B2 $90 $90 $90 $90 $90 #Ignore bullet code (Not needed)
#If shot blow up, do nothing else $37 (101BA-F8 free now) $0701W $0F80RW
%patch $10181 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $90 $90 $90 $90 $90
              $90 $90 $90 $90 $90 $90 $90 $90 $90 $83 $3D $03 $75 $18 $C7 $44 $16
              $00 $00 $C7 $44 $06 $01 $00 $B8 $98 $21 $50 $57 $56 $9A $09DC1695RL
              $83 $C4 $06 $5F $5E $5D $CB
#Dissapear when shot, also kill (No space free) $073BW $0F80RW
%patch $101BB $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $09
              $9A $0B8013E9RL $5F $5E $5D $CB $83 $3D $03 $75 $18 $C7 $44 $16
              $00 $00 $C7 $44 $06 $01 $00 $B8 $98 $21 $50 $57 $56 $9A $09DC1695RL
              $83 $C4 $06 $5F $5E $5D $CB
%patch $100B9 $01 $77 #Make eggs hatch when *Anything* hits them
%patch $10605 $01 $00 #Skypest (Egg doesn't appear in front of stuff)
%patch $30FCC $6B $01 $6B $01 #Shell fragment
%patch $100D7 $5C $21 #Switch large shell/small shell 1
%patch $10171 $3E $21 #So that Bird now appears in FRONT of spawner
%patch $100CF $05 $00 #Shell fragment can hatch regenerated egg to restart cycle
%patch $10106 $80 $01 #Height egg's contents spawn (1.5 tiles up)
%patch $10135 $6A $22 #What hatches from eggs [Flying bird]


###
#Bird (Now an attcker, 2 modes, air and ground)
###
#Two kinds, flying and not
%patch $10299 $06 $00       #Up ACCELERATION when flying
%patch $102AD $06 $00       #Down ACCELERATION when flying
%patch $10221 $00 $13       #Never fly up after Keen when walking (Keen would have to be up offscreen)
%patch $10310 $C2 $33       #Bird damaged when shot again
%patch $3113E $00 $03       #Stop Bird landing animation
%patch $31170 $016FW $016FW #Unstunning Bird uses
%patch $3118E $0170W $0170W #four walking Bird frames
%patch $311AC $0171W $0171W #as it unstuns instead
%patch $311CA $0172W $0172W #of stunned/walk frames
%patch $31060 $D4 $21       #Walking Bird uses one frame
%patch $31044 $0177W $0177W #to 'slide-walk'
%patch $31054 $0FA80779RL   #and chases Keen like hell
%patch $103D0 $72
%patch $10489 $00
%patch $103D3 $4C $22       #Birds don't land on
%patch $10499 $6A $22       #ground when flying
%patch $310BC $0178W $0178W #Flying bird has 3 frames
%patch $10099 $E2 $22       #Spawn Bird (Stunned, waits then attacks)
%patch $3105C $09DC1795RL   #Walking bird uses Arachnut tile detection
%patch $3107A $09DC1795RL   #Walking
%patch $31098 $09DC1795RL   #Walking
%patch $310B6 $09DC1795RL   #Walking



###
#Skypest
###
#Now an annoying bug; wait, has it changed?
%patch $106B5 $06 $00 #Speed l/r while flying
%patch $106C5 $06 $00 #Speed u/d while flying
%patch $105FB $03 $00 #Skypest blast disappears when it hits stuff [Keen bullet type]
%patch $1076B $03 $00 #Its squished slime is dangerous too
%patch $FFFB  $00 $00 #Egg (This now changes the Skypest foreground behavior!)


###
#Airboards
###
#Fallable airboard uses spare Zoltan animations
%patch $31FF8 $67 $01 $67 $01 #Resting
%patch $32016 $68 $01 $68 $01 #Falling
%patch $32034 $69 $01 $69 $01 #Rising
%patch $1193E $01 $00         #Droppable Platform rests on ground
%patch $1182D $E5 $01         #Airboard moving up left side flame
%patch $11853 $E5 $01         #Airboard moving up right side flame
%patch $11887 $E5 $01         #Airboard moving down/still left side flame
%patch $118AD $E5 $01         #Airboard moving down/still right side flame
%patch $117A2 $58 $00         #Board moving right flame v
%patch $117A9 $C0 $FE         #Moving left flame h (REVERSED)
%patch $11804 $58 $00         #Moving left flame v
%patch $1180B $50 $00         #Moving right flame h
%patch $11834 $30 $00         #Moving up left flame v
%patch $1183B $C0 $00         #Moving up left flame h
%patch $1185A $30 $00         #Moving up right flame v
%patch $11861 $C0 $00         #Moving up right flame h
%patch $1188E $90 $00         #Moving down left flame v
%patch $11895 $C0 $00         #Moving down left flame h
%patch $118B4 $90 $00         #Moving down right flame v
%patch $118BB $C0 $00         #Moving down right flame h




###
#Bounder
###
%patch $31D8C $01 $00 #Change anim speeds for rapid flick
%patch $31DAA $01 $00
%patch $31DC8 $01 $00
%patch $31DE6 $01 $00
%patch $31E34 $12 $2F #Behaviour adjust 3 (Stunned bounder keeps on bounding)
%patch $31DFA $F1 $01 $F1 $01 #Sprites of stunned bounder
%patch $11174 $0F $00 #Shot Bounder behavior
%patch $11179 $7F     #Bounder shot jump (Max $7F)
%patch $111BC $00 $00 #Bounder Jump height (Crawl)
%patch $111AE $06 $00 #Bounder bounce sound


###
#Berkeloid (Now a 'walking nose')
###
%patch $319C2 $F8 $01 $FC $01 #Sprite adjust 1 (Berkeloid start)
%patch $31C1A $05 $02 $05 $02 #Sprite adjust 2 (Shooting)
%patch $31C38 $06 $02 $06 $02 #Sprite adjust 3
%patch $31C56 $05 $02 $05 $02 #Sprite adjust 4
%patch $31C74 $06 $02 $06 $02 #Sprite adjust 5
%patch $31972 $0A $00 #Animation speed 2
%patch $31990 $0A $00 #Animation speed 3
%patch $319AE $0A $00 #Animation speed 4
%patch $319CC $0A $00 #Animation speed 5
%patch $10BCB $00 $FE #Spawn height (1 tile up)
%patch $10DEC $00 $00 #Hover strength (None)
%patch $10CDB $20 $00 #Right speed
%patch $10CF4 $E0 $FF #Left speed
%patch $10D89 $AA $2D #Berkeloid flame [When hits ground, now doesn't 'go big']

###
#Smirky (Still the same, really) [Frees up 1 frame at 31E2)
###
%patch $11A4C $01 $00 #Smirky now doesn't go in front of fore tiles
%patch $11A8B $00 $32 #Remove 1 frame of Standing Smirky,
%patch $11E14 $00 $32 #This makes Smirky jump-squish
%patch $32070 $52 $01 #Sprite l (Give different l\rs)
%patch $32072 $53 $01 #Sprite r
%patch $3207A $18 $00 #Animation speed
%patch $3207C $20 $00 #Landing moves across this much
%patch $11B64 $B0 $FF #Smirky big jump height (All are now smaller.)
%patch $11BE7 $0C $00 #Small jump l/r speed
%patch $11BF1 $EA $FF #Small jump height
%patch $11C38 $0C $00 #Small turnaround jump l/r speed
%patch $11C42 $EA $FF #Small turnaround jump height
%patch $11A4C $00 $00 #Change Smirky foreground behavior
%patch $11CB0 $00 $00 #Smirky stolen items spark
%patch $11DA9 $00 $00 #Smirky stolen tiles spark
%patch $11A5E $30 $FF #Smirky spawn on ground height
%patch $11C69 $90 $00 #Smirky spawn on ground when telep

%patch $32098 $08 $00 #Animation speed
%patch $320B6 $08 $00 #Animation speed
%patch $320D4 $08 $00 #Animation speed
%patch $320F2 $20 $00 #Animation speed
%patch $32110 $20 $00 #Animation speed
%patch $3212E $08 $00 #Animation speed
%patch $3214C $08 $00 #Animation speed
%patch $3216A $08 $00 #Animation speed



###
#Clooud
###
%patch $10A36 $00 $00 #Cloud doesn't drift
%patch $10AC6 $00 $01 #Cloud special when zapping
%patch $10A80 $0A $00 #Cloud doesn't move after zapping
%patch $10B43 $19 $00 #Lightening 02,3c in 6.4 (083c)

###
#Lindsey (Now an eye thing)
###
%patch $32764 $20 $01 #Animation speed 1
%patch $32782 $08 $00 #Animation speed 2
%patch $327A0 $08 $00 #Animation speed 3
%patch $327BE $08 $00 #Animation speed 4
%patch $12829 $01 $00 #Floating u/d speed
%patch $1283F $00 $01 #Floating u time (Increase this to make sprite float slower)
%patch $1284F $00 $01 #Floating d time (when distance is made large.)

###
#Wetsuit (Now a bouncing Xky alien)
###
%patch $328C0 $12 $3B #Have two animations
%patch $328A4 $FA $01 #Sprite l
%patch $328A6 $FA $01 #Sprite r
%patch $328AE $30 $00 #Animation speed
%patch $32982 $FE $01 $FE $01 $00 $00 $00 $00 $00 $00 $30 $00 $00 $00 $00 $00
              $00 $00 $00 $00 $1010W  $11A2RW $176EW  $09DCRW $34 $3A

###
#Schoolfish (Now a tracking mine)
###

#Make fish slow mines:
%patch $325E8 $11A20D86RL #Schoolfish explode like mine;
%patch $32606 $11A20D86RL #Mine: Kill Keen and produce exploded Mine
%patch $12558 $05 $00 #Speed up
%patch $1256C $05 $00 #Speed down
%patch $1253C $05 $00 #Speed l/r

#Add two extra actions for 4-way frames (13\11 actions remain?)
%patch $325D4 $01A5W $01A8W  $0003W $0000W $0000W $0014W $0000W $0000W #Use mine collision
              $0AF6W $11A2RW $11A20D86RL   $11A20A3CRL   $3782W
%patch $325F2 $01A6W $01A7W  $0003W $0000W $0000W $0014W $0000W $0000W #Use extra frame
              $0AF6W $11A2RW $11A20D86RL   $11A20A3CRL   $2558W #3764W
%patch $313C8 $01A7W $01A6W  $0003W $0000W $0000W $0014W $0000W $0000W #
              $0AF6W $11A2RW $11A20D86RL   $11A20A3CRL   $2576W
%patch $313E6 $01A8W $01A5W  $0003W $0000W $0000W $0014W $0000W $0000W #Return to initial frame
              $0AF6W $11A2RW $11A20D86RL   $11A20A3CRL   $3764W

#Schoolfih mine explosion death uses extra skypest anim too
%patch $3271E $01B9W $01B9W $0000w $0000w $0000w $0010W  $0000w $0000w
              $0000w $0000w $0000W $0000w $176EW $09DCRW $38CCW
%patch $3273C $01BAW $01BAW $0000w $0000w $0000w $0010W  $0000w $0000w #Goto extra action
              $0000w $0000w $0000W $0000w $176EW $09DCRW $2594W
%patch $31404 $01BFW $01BFW $0000w $0000w $0000w $0130W  $0000w $0000w #Don't vannish
              $0000w $0000w $0000W $0000w $176EW $09DCRW $33C2W

###
#Mine (Hammer)
###

%patch $32714 $09DC1752RL #Mine doesn't explode


###
#Dopefish (Now a helper)
###

%patch $120C4 $16 $00 #Fish eats schoolfish (And each other!)


###
#Sprite (Shooting bot)
###

%patch $125D9 $00 $00 #Stop sprite floating much
%patch $125EF $04 $00 #by limiting his floating times/speeds
%patch $125EF $04 $00 #Floating d time
%patch $326C2 $18 $38 #Shot has only 2 frames
%patch $32694 $10 $00 #Speed h 1 (Slow bullet 3x)
%patch $326B2 $10 $00 #Speed h 2
%patch $326D0 $10 $00 #Speed h 3
%patch $326EE $10 $00 #Speed h 4
%patch $3261A $04 $00 #Animation speed
%patch $32656 $08 $00 #Pause before shooting
%patch $32674 $28 $00 #Pause before floating

###
#Arachnut (Now a napping statue... and more)
###

#First all placed Arachnuts are stunned
%patch $1056B $F0 $23 #Spawn walking Arachnut
%patch $3127C $F0 $23 #Arachnut stunned [Go to unstun]
%patch $3126A $0010W  #Stun time (POOF!)

#Now when *anything* touches sleeping 'nut, it awakes, this
#lets us place candy items next to it to 'spawn' awake 'nuts
%patch $105D5 $0E $24    #Arachnut when stunned and shot [Awaken]
%patch $105D1 $02        #Awaken if touched by anything BUT
%patch $105D2 $76        #Keen, sadly, Keen is exempt, unless Godmode...
%patch $31292 $00000000L #Arachnut harmless when unstunning
%patch $312B0 $00000000L #At least for first two frames.
%patch $3127E $01AE01AEL #Arachnut unstunning 1
%patch $31288 $18 $00    #Animation speed
%patch $3129C $01AD01ADL #Arachnut unstunning 2
%patch $314A6 $08 $00    #Animation speed
%patch $312BA $01AE01AEL #Arachnut unstunning 3
%patch $314C4 $1A $00    #Animation speed
%patch $312D8 $01AD01ADL #Arachnut unstunning 4
%patch $314E2 $04 $00    #Animation speed


###
#Darts (Now 4 different pseudo-arachnut)
##

%patch $1292B $03 $00 #Darts (Keen's shot type, so interact with stuff)


###
#Mimrock (Now a ghost)
###

%patch $11E85 $01 $00 #Mimrock  clips behind foreground


#############################################
#Game Text Patches                          #
#############################################

###
#Story
################################
%patch $1EE40
"ShadowKeen Four" $0A $0A

"Zoltan's Revenge" $0A $0A

"After roundly defeating" $0A
"Duke Nukum and again" $0A
"thwarting the plans of" $0A
"Mortimer, Keen heads" $0A
"home for some well" $0A
"deserved R and R." $0A $0A
%patch $1EEE2
"After enjoying several" $0A
"months of carefree" $0A
"inventing, Keen" $0A
"recieves yet another" $0A
"Ominous message on his" $0A
"Phototachyon" $0A
"Transciever." $0A $0A $0A
%patch $1EF64
"Angry at his defeat at" $0A
"Keen's hands not once," $0A
"but TWICE, Zoltan has" $0A
"built a time randomizer" $0A
"and is warping the" $0A
"fabric of the universe." $0A $0A
%patch $1EFEC
"Without hesitation Keen" $0A
"Launches the BwB and" $0A
"Makes his way to" $0A
"Zoltan's Lair..." $00


###
#Cheats
###
#Have some fun! (Leaves space free to insert new sprite behaviors!)
%patch $2F4DD "Hey! No cheating!" $00
#Disable all F10 cheats!
#%patch $749E $5F $5E $8B $E5 $5D $CB
#Cheat option (BAT)
%patch $7840 $30     #Disable
%patch $785A $06 $00 #Window height
%patch $785E $10 $00 #Window width
%patch $786F $C5 $05 #Text called from
%patch $788D $00 $02 #Shots given
%patch $7894 $00 $00 #Keys given (1 of each)
%patch $2F435 "Super Shot!" $0A $0A
              "500 shots and" $0A
              "an extra keen!" $00
"Zoltan's Lair..." $00



###
#Council members
###


%patch $2F49C "STUFF" $00


###
#Misc
###

%patch $3375F "BONE WAR" $00
#Relocate GRAPH and AUDIO names for a  bit more space: (Only 1 byte wasted.)
%patch $3293A "EGAGRAPH.CK4" $00 "AUDIO.CK4" $00
%patch $131C3 $CA $3A #Look for GRAPH name
%patch $13393 $D7 $3A #Look for AUDIO name New string at $3295F


#############################################
#Levels and Level Text                      #
#############################################

#Names
%patch $1F040 "Lira" $00
%patch $1F050 "The Pit" $00
%patch $1F060 "Crystal Caves" $00
%patch $1F070 "The Dark Forest" $00
%patch $1F090 "Defense Post 1" $00
%patch $1F0B0 "NMR Facility" $00
%patch $1F0C0 "Spike Factory" $00
%patch $1F0D0 "Muon Forest" $00
%patch $1F0E0 "Defense Post 2" $00
%patch $1F0F0 "Diamond Mines" $00
%patch $1F100 "Mt Improbable" $00
%patch $1F110 "Freezer Burn" $00
%patch $1F130 "Down the Drain" $00
%patch $1F150 "The Pyramid Of The" $0A
              "Impossible" $00

#What Keen does to levels
%patch $1F1F0 "Keen explores Lira" $00
%patch $1F210 "Keen drops in on" $0A 
              "The Pit" $00
%patch $1F240 "Keen spelunks" $0A 
              "into Crystal Cave" $00
%patch $1F260 "Keen hikes through" $0A 
              "the Dark Forest " $00
%patch $1F290 "Keen attacks Defense" $0A
              "Post One" $00
%patch $1F2D0 "Keen is attracted to" $0A
              "the NMR Facility" $00
%patch $1F300 "Keen plays in the Video" $0A
              "Game Spike Factory" $00
%patch $1F330 "Keen accelerates" $0A
              "in Muon Forest" $00
%patch $1F350 "Keen sets Defence Post" $0A
              "Two ablaze!" $00
%patch $1F380 "Keen gleams in the" $0A
              "Diamond Mines" $00
%patch $1F3A0 "Keen admires the view" $0A
              "from Mount Improbable" $00
%patch $1F3D0 "Ice in a volcano?" $0A
              "That's Freezer Burn!" $00
%patch $1F400 "Keen watches as" $0A
              "everything goes Down" $0A
              "The Drain!" $00
%patch $1F430 "Keen just can't get" $0A
              "through The Pyramid" $0A
              "Of The Impossible!" $00

%patch $1F540 "Keen examines his" $0A 
              "BwB Megarocket." $00
%patch $2F191 "   Exit to Lira    " $00

%patch $2F55C "Prepare to die," $0A
              "Commander Keen!" $0A $0A
              "-Zoltan" $00

#Bitmap cache (3 bitmaps, 104-6)
%patch $F4AE $6E $00 #Cache Council Member graphic
%patch $F4B5 $6F $00 #Cache Talking Keen head
%patch $F4BC $70 $00 #Cache Keen's thumbs up 

#Council member window
%patch $F4DB $08 $00                 #Height
%patch $F4DF $1A $00                 #Width
%patch $F4EB $6E $00                 #Bitmap displayed + 6 (Show BMP 104)
%patch $F523 $A7 $1D                 #Text read from
%patch $F534 $3C $00                 #Time window remains open before reply

#Keen's reply window
%patch $F54A $08 $00                 #Height
%patch $F44E $1A $00                 #Width
%patch $F55A $6F $00                 #Bitmap displayed + 6 (Show BMP 105)
%patch $F569 $30 $00                 #Bitmap position from RIGHT of screen (Bitmap is centered vertically)
%patch $F596 $1E $00                 #Pause after keypress before Keen gives thumbs up
%patch $F5AC $70 $00                 #Keen's thumbs up bitmap
%patch $F5C6 $1E $00                 #Pause before Exit to Shadowlands window appears
%patch $3084C $01 $1C                #Text read from 1
%patch $3084E $22 $1C                #Text read from 2
%patch $30850 $43 $1C                #Text read from 3
%patch $30852 $50 $1C                #Text read from 4
%patch $30854 $90 $1C                #Text read from 5
%patch $30856 $A3 $1C                #Text read from 6
%patch $30858 $D4 $1C                #Text read from 7
%patch $3085A $FB $1C                #Text read from 8



%end